/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.common.compats.minecraft.looking;

import codersafterdark.compatskills.utils.Utils;
import codersafterdark.reskillable.api.requirement.Requirement;
import codersafterdark.reskillable.api.requirement.RequirementComparision;
import codersafterdark.reskillable.api.requirement.RequirementException;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class LookingAtBlockRequirement
extends Requirement {
    private final List<IProperty<?>> watchedProperties;
    private final IBlockState state;
    private final IBlockState defaultState;

    public LookingAtBlockRequirement(IBlockState state, List<IProperty<?>> watchedProperties) {
        this.state = state;
        this.defaultState = state.func_177230_c().func_176223_P();
        this.watchedProperties = watchedProperties;
        StringBuilder displayInfo = new StringBuilder(state.func_177230_c().func_149732_F());
        int size = watchedProperties.size();
        if (size > 0) {
            displayInfo.append(" {");
        }
        for (int i = 0; i < size; ++i) {
            IProperty<?> property = watchedProperties.get(i);
            displayInfo.append(property.func_177701_a()).append(": ").append(state.func_177229_b(property));
            displayInfo.append(i + 1 == size ? "}" : ", ");
        }
        this.tooltip = TextFormatting.GRAY + " - " + TextFormatting.DARK_GREEN + new TextComponentTranslation("compatskills.requirements.format.looking_at", new Object[]{"%s", displayInfo.toString()}).func_150261_e();
    }

    public static LookingAtBlockRequirement fromString(String input) throws RequirementException {
        if (input.isEmpty()) {
            throw new RequirementException("No Block given.");
        }
        String[] inputInfo = input.split("\\|");
        String blockName = inputInfo[0];
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
        if (block == null) {
            throw new RequirementException("No Block found matching: '" + blockName + "'.");
        }
        IBlockState blockState = block.func_176223_P();
        ArrayList watchedProperties = new ArrayList();
        if (inputInfo.length > 1) {
            JsonObject properties;
            String props = input.substring(blockName.length() + 1);
            try {
                properties = (JsonObject)new JsonParser().parse(props);
            }
            catch (JsonParseException e) {
                throw new RequirementException("Invalid properties json: '" + props + "'.");
            }
            BlockStateContainer blockStateContainer = block.func_176194_O();
            for (Map.Entry entry : properties.entrySet()) {
                IProperty property = blockStateContainer.func_185920_a((String)entry.getKey());
                if (property == null) {
                    throw new RequirementException("Failed to find property: '" + (String)entry.getKey() + "'.");
                }
                blockState = LookingAtBlockRequirement.setValueHelper(blockState, property, ((JsonElement)entry.getValue()).getAsString());
                watchedProperties.add(property);
            }
        }
        return new LookingAtBlockRequirement(blockState, watchedProperties);
    }

    private static <T extends Comparable<T>> IBlockState setValueHelper(IBlockState blockState, IProperty<T> property, String stringValue) throws RequirementException {
        return property.func_185929_b(stringValue).toJavaUtil().map(propertyValue -> blockState.func_177226_a(property, propertyValue)).orElseThrow(() -> new RequirementException("Failed to find value " + stringValue + " for property " + property.func_177701_a()));
    }

    public boolean achievedByPlayer(EntityPlayer player) {
        RayTraceResult rayTrace = Utils.getLookingAt(player);
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            IBlockState lookingAt = player.func_130014_f_().func_180495_p(rayTrace.func_178782_a());
            if (this.state == lookingAt) {
                return true;
            }
            if (this.defaultState != lookingAt.func_177230_c().func_176223_P()) {
                return false;
            }
            return this.watchedProperties.stream().allMatch(property -> this.state.func_177229_b(property).equals(lookingAt.func_177229_b(property)));
        }
        return false;
    }

    public RequirementComparision matches(Requirement o) {
        return o instanceof LookingAtBlockRequirement && this.state == ((LookingAtBlockRequirement)o).state ? RequirementComparision.EQUAL_TO : RequirementComparision.NOT_EQUAL;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof LookingAtBlockRequirement && this.state == ((LookingAtBlockRequirement)((Object)obj)).state;
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    public boolean isCacheable() {
        return false;
    }
}

